$name= Read-Host -Prompt "Enter user name"
if ($(Get-ScheduledTask -TaskName "wintrack2" -ErrorAction SilentlyContinue).TaskName -eq "wintrack2") {
    Unregister-ScheduledTask -TaskName "wintrack2" -Confirm:$False
    
}

# The name of your scheduled task.
$taskName = "wintrack2"

# Describe the scheduled task.
$description = "Windows applications usage tracking"

# Create a new task action
$taskAction = New-ScheduledTaskAction `
    -Execute 'C:\Python312\pythonw.exe' `
    -Argument 'C:\Database\data\tracker.py'


# Create a new trigger
 
$trigger = New-ScheduledTaskTrigger -Once -At (Get-Date) -RepetitionInterval (New-TimeSpan -Minutes 1)


# Setting
$settings = New-ScheduledTaskSettingsSet -StartWhenAvailable -AllowStartIfOnBatteries -DontStopIfGoingOnBatteries -ExecutionTimeLimit 10000.00:00:00

# Register the scheduled task
Register-ScheduledTask -TaskName $taskName -Action $taskAction -Trigger $trigger -Settings $settings -Description $description -User $name

